library(lavaan)
library(psych)
setwd('U:/MyStuff/cls/p205c/EXAMPLES/holzinger/r')

#-------------------------------------------------------------------------------------------------#
# reading a data set into R (data in ASCII format, with . for missing values)                     #
#   change element in na.strings statement to substitute a different missing value (e.g., -99)    #
#-------------------------------------------------------------------------------------------------#

hs39all = read.table(file = 'U:/MyStuff/cls/p205c/EXAMPLES/holzinger/r/hs39all_raw.txt',
                       na = '.')
#-------------------------------------------------------------------------------------------------#
# NOTE: Read in the "raw-scored" version of the Holzinger-Swineford 1939 data                     #
#-------------------------------------------------------------------------------------------------#
head(hs39all)
dim(hs39all)

names(hs39all) = c('case'    , 'school'  , 'grade'   , 'female'  , 'ageyr'  , 'mo'      , 'agemo', 
                   'visperc' , 'cubes'   , 'frmbord' , 'lozenges', 'geninfo', 'paracomp',
                   'sentcomp', 'wordclas', 'wordmean', 'addition', 'code'   , 'countdot', 
                   'sccaps'  , 'wordrecg', 'numbrecg', 'figrrecg', 'objnumb', 'numbfig' , 
                   'figword' , 'deducton', 'numbpuzz', 'probreas', 'series' , 'woody'   , 
                   'frmbord2', 'flags'   )
head(hs39all)
#-------------------------------------------------------------------------------------------------#
# NOTE: done! "raw-scored" version of the Holzinger-Swineford 1939 data read in                   #
#-------------------------------------------------------------------------------------------------#


hs.model1 = '
            spatial  =~ visperc  + cubes    + lozenges
            verbal   =~ geninfo  + paracomp + sentcomp 
            memory   =~ wordrecg + numbrecg + numbfig
            reason   =~ deducton + numbpuzz + series
            '

fit1 = cfa(hs.model1, data = hs39all, group="female")
summary(fit1, fit.measures = TRUE, standardized = TRUE)
inspect(fit1)



